 ; Ŀ
 ;   Il - isometric line drawer with automatic radii.                      
 ;   Copyright 1994, 2010 by Rocket Software Ltd.                          
 ;   Just what are the evolutionary forces on a goldfish?                  
 ; 

 ; Ŀ
 ;   Tuna - find the inside angle between two lines.                       
 ; 
 (DEFUN TUNA (ang1 ang2 / angg)
  (if (> ang1 ang2)
      (setq angg (- ang1 ang2))
      (setq angg (- ang2 ang1)))
  (if (> angg pi)
      (setq angg (abs (- angg (* 2 pi)))))
  angg)
 ; Ŀ
 ;   Tuna end.                                                             
 ; 

 ; Ŀ
 ;   Codton - fillet the lines and draw the welds.                         
 ; 
 (DEFUN CODTON (enta entb / plast dimsc lina linb tena elvna tenb elvnb lenga
                  lengb pa ang1 ang2 p1 p2 angg fil top base top1 base1 elast)
  (setq plast (entlast))
  (setq dimsc (getvar "dimscale"))
  (setq lina (entget enta))
  (setq linb (entget entb))
  (setq tena  (cdr (assoc 10 lina)))
  (setq elvna (cdr (assoc 11 lina)))
  (setq tenb  (cdr (assoc 10 linb)))
  (setq elvnb (cdr (assoc 11 linb)))
  (setq lenga (distance tena elvna))
  (setq lengb (distance tenb elvnb))
  (if (setq pa (inters tena elvna tenb elvnb nil))
      (progn
           (if (< (distance pa tena) (distance pa elvna))
               (setq ang1 (angle tena elvna))
               (setq ang1 (angle elvna tena)))
           (if (< (distance pa tenb) (distance pa elvnb))
               (setq ang2 (angle tenb elvnb))
               (setq ang2 (angle elvnb tenb)))
           (setq p1 (polar pa ang1 (* dimsc 5)))
           (setq p2 (polar pa ang2 (* dimsc 5)))
 ; Ŀ
 ;   Call tuna to find the angle, set Filletrad accordingly.               
 ; 
           (setq angg (tuna ang1 ang2))
           (if (> angg (/ pi 2))
               (progn
                    (setq fil 5)
                    (setvar "filletrad" (* dimsc 5)))
               (progn
                    (setq fil 2)
                    (setvar "filletrad" (* dimsc 2))))
 ; Ŀ
 ;   See if the lines are long enough to fillet at the current radius and  
 ;   angle. If fil = 5 then the angle was 120 and lines at least 2.89     
 ;   units long are required.  If fil = 2 then the angle was 60 and 3.46  
 ;   will be removed from the end of each line by the fillet command.      
 ; 
           (if (or (and(= fil 2)(> lenga (* 3.5 dimsc))(> lengb (* 3.5 dimsc)))
                   (and (= fil 5) (> lenga (* 3 dimsc)) (> lengb (* 3 dimsc))))
               (command "fillet" (list enta p1) (list entb p2)))))
 ; Ŀ
 ;   If a new entity was created, return its entity name.                  
 ; 
 (if (not (equal plast (setq elast (entlast))))
     elast))
 ; Ŀ
 ;   Codton end.                                                           
 ; 

 ; Ŀ
 ;   IL.                                                                   
 ; 
 (DEFUN C:IL (/ *error* ss snast prev ison pa aa prelast llast isopl)
  (setvar "cmdecho" 0)
  (command ".undo" "be")
 ; Ŀ
 ;   Previously Sailfish, now a local error handler.                       
 ; 
  (defun *error* (shk)
 ; Ŀ
 ;   Make all the lines and arcs into a polyline.                          
 ; 
   (if (and ss (> (sslength ss) 1))
       (command ".pedit" (ssname ss 0) "y" "j" ss "" ""))
 ; Ŀ
 ;   Clean up some other settings.                                         
 ; 
   (if snast (setvar "snapstyl" snast))
   (command ".undo" "end")
   (if (and shk (/= shk "Function cancelled"))
       (write-line shk))
  (princ))
 ; Ŀ
 ;   Make sure Iso is on.                                                  
 ; 
  (if (= (setq snast (getvar "snapstyl")) 0)
      (progn
           (initget 0 "Yes No")
           (setq ison (getkword "Shouldn't Iso be on? <Y>: "))
           (if (or (null ison) (= ison "Yes"))
               (setvar "snapstyl" 1))))
 ; Ŀ
 ;   Draw some lines.                                                      
 ; 
  (setq pa (getpoint "Start: "))
  (while T
         (setq aa (getpoint pa))
         (if aa
             (progn
                  (command "line" pa aa "")
                  (if ss
                     (ssadd (entlast) ss)
                     (setq ss (ssadd (entlast))))
                  (if llast (setq prelast llast))
                  (setq llast (entlast))
                  (if (and prelast llast)
                      (setq nunam (codton prelast llast)))
                  (if nunam (ssadd nunam ss))
                  (setq pa aa))
             (progn
                  (setq isopl (getvar "snapisopair"))
                  (if (= isopl 2)
                      (setvar "snapisopair" 0)
                      (setvar "snapisopair" (1+ isopl))))))
 ; Ŀ
 ;   Clean up and end.                                                     
 ; 
  (*error* nil)
 (princ))